using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace BatCompiler
{
    public partial class Options : Form
    {
        public Options()
        {
            InitializeComponent();
            this.Icon = Properties.Resources.bat;
        }

        private void Options_Load(object sender, EventArgs e)
        {
            this.Savecheck.Checked = Properties.Settings.Default.Saveexe;
            this.HiddenCheck.Checked = Properties.Settings.Default.RunHidden;

            this.CustomRadio.Checked = Properties.Settings.Default.Customicon;
            if (!string.IsNullOrEmpty(Properties.Settings.Default.iconpath))
            {
                this.pathtextbox.Text = Properties.Settings.Default.iconpath;
                this.pictureBox1.Image = Image.FromFile(Properties.Settings.Default.iconpath);
            }

        }

        private void Options_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.Saveexe = this.Savecheck.Checked;
            Properties.Settings.Default.RunHidden = this.HiddenCheck.Checked;
            Properties.Settings.Default.Customicon = this.CustomRadio.Checked;
            Properties.Settings.Default.iconpath = this.pathtextbox.Text;

            Properties.Settings.Default.Save();
        }

        private void CustomRadio_CheckedChanged(object sender, EventArgs e)
        {
            this.pathtextbox.Enabled = CustomRadio.Checked;
            this.choosebutton.Enabled = CustomRadio.Checked;
        }

        private void choosebutton_Click(object sender, EventArgs e)
        {
            if (icondialog.ShowDialog() == DialogResult.OK)
            {
                this.pathtextbox.Text = icondialog.FileName;
                this.pictureBox1.Image = Image.FromFile(icondialog.FileName);
            }
        }
    }
}